function pob = calClassificationError(w, data1, data2, u1, sigma1, u2, sigma2)
    m1 = u1' * w;
    m2 = u2' * w;
    v1 = w(1)^2 * sigma1(1) + w(2)^2 * sigma1(2);
    v2 = w(1)^2 * sigma2(1) + w(2)^2 * sigma2(2);
    [N, t] = size(data1);
    error = 0;
    for k = 1 : N;
        y = data1(k, :) * w;
        lh1 = 1 / sqrt(2 * pi * v1) * exp(- (y - m1)^2 / 2 / v1);
        lh2 = 1 / sqrt(2 * pi * v2) * exp(- (y - m2)^2 / 2 / v2);
        if (lh1 < lh2)
            error = error + 1;
        end;
        y = data2(k, :) * w;
        lh1 = 1 / sqrt(2 * pi * v1) * exp(- (y - m1)^2 / 2 / v1);
        lh2 = 1 / sqrt(2 * pi * v2) * exp(- (y - m2)^2 / 2 / v2);
        if (lh1 >= lh2)
            error = error + 1;
        end;
    end;
    pob = error / 2 / N;