function plotDirection(w, axis_range, type)
    xmin = axis_range(1);
    xmax = axis_range(2);
    ymin = axis_range(3);
    ymax = axis_range(4);
    step = w / 1000;
    data = [0; 0];
    for k = 1 : 1e30;
        x = step(1) * k;
        y = step(2) * k;
        if ((x > xmax) || (x < xmin) || (y > ymax) || (y < ymin))
            break;
        end;
        data = [data, step * k];
    end;
    if (type == 1)
        plot(data(1, :), data(2, :), 'b-', 'LineWidth', 2);
    elseif (type == 2)
        plot(data(1, :), data(2, :), 'c:', 'LineWidth', 2);
    elseif (type == 3)
        plot(data(1, :), data(2, :), 'm-.', 'LineWidth', 2);
    elseif (type == 4)
        plot(data(1, :), data(2, :), 'y--', 'LineWidth', 2);
    end;