clear; clc; close all;
u1 = [4, 3]';
sigma1 = [2, 1]';
u2 = [2, 5]';
SIG2 = [1 2 3;
        1 2 3];
data1 = Gaussian2D(u1, sigma1, 500);

for k = 1 : 3;
    sigma2 = SIG2(:, k);
    data2 = Gaussian2D(u2, sigma2, 500);
    [w_pca_l, w_pca_m] = calPCA([data1; data2]);
    w_fisher = calFisher(data1, data2);
    w_mean = (mean(data1 - data2))' / norm((mean(data1 - data2))');
    
    figure(k);
    plot(data1(:, 1), data1(:, 2), 'r.');
    hold on;
    plot(data2(:, 1), data2(:, 2), 'g.');
    axisrange = [-8, 8, -8, 8];
    axis(axisrange);
    grid on;
    plotDirection(w_pca_l, axisrange, 1); hold on;
    plotDirection(w_pca_m, axisrange, 2); hold on;
    plotDirection(w_fisher, axisrange, 3); hold on;
    plotDirection(w_mean, axisrange, 4); hold on;
end;